/****** Object:  Trigger [TRG_EST_NF_SAI_INCLUI_EXCLUI_PENDENCIA]    Script Date: 01/22/2014 12:31:46 ******/
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_EST_NF_SAI_INCLUI_EXCLUI_PENDENCIA]'))
DROP TRIGGER [dbo].[TRG_EST_NF_SAI_INCLUI_EXCLUI_PENDENCIA]
GO
GO
GO
GO
CREATE TRIGGER [dbo].[TRG_EST_NF_SAI_INCLUI_EXCLUI_PENDENCIA] ON [dbo].[EST_NF_SAI] FOR UPDATE AS
IF NOT UPDATE(CD_NT_MOV)
IF NOT UPDATE(NFE_REJEITADA)
IF NOT UPDATE(UUID)
IF EXISTS(SELECT CD_USU FROM
			INSERTED WHERE CD_USU <> 1)
	begin
		--Proibe alterao na nota fiscal de sada quando j existe registro da transferncia
		IF EXISTS (SELECT TOP 1 T.CD_EMP FROM 
						EST_NF_ENT_EST_NF_SAI_TRANSF t INNER JOIN DELETED s  ON 
						t.CD_FIL_ORIG=s.CD_FILIAL AND 
						t.CD_EMP=s.CD_EMP AND 
						t.CD_NF_SAI=s.CD_NF)
		begin
			RAISERROR ('Nota fiscal com confirmacao de entrada no destino, alteracao cancelada.',16, 1); 
			RETURN;
		end 
	end
		--Verifica se alterou campos que podem criar condies para entrada ou sada na pendncia de entrada
		begin
			--Pendncia de entrada de nota fiscal de transferencia
			INSERT INTO EST_NF_SAI_PENDENCIA(CD_EMP, CD_FILIAL, CD_NF, CD_FILIAL_DEST)
			SELECT DISTINCT 
				CD_EMP, 
				CD_FILIAL, 
				CD_NF, 
				CD_CLI
			FROM 
				INSERTED s
			WHERE 
				STS_NF=0 
				AND PEND_ENTRADA=0  --nao cancelada, pendente de entrada
				AND CD_NT_MOV IN (SELECT CD_MOV_OP FROM GLB_MOV_OP WHERE DEST_ORIG=2 AND TP_MOV <> 28) --origem filial
				AND NOT EXISTS (SELECT  TOP 1 CD_EMP
								FROM 
									EST_NF_ENT_EST_NF_SAI_TRANSF
								WHERE 
									CD_FIL_ORIG=s.CD_FILIAL AND 
									CD_EMP=s.CD_EMP AND 
									CD_NF_SAI=s.CD_NF)
				AND NOT EXISTS (SELECT  TOP 1 CD_EMP
								FROM 
									EST_NF_SAI_PENDENCIA
								WHERE 
									CD_FILIAL=s.CD_FILIAL AND 
									CD_EMP=s.CD_EMP AND 
									CD_NF=s.CD_NF) 
				DELETE FROM 
					f     ---->estava na tabela de trabalho e perdeu uma das condies
				FROM 
					EST_NF_SAI_PENDENCIA f INNER JOIN INSERTED s ON 
					f.CD_FILIAL=s.CD_FILIAL AND 
					f.CD_EMP=s.CD_EMP 
					AND f.CD_NF=s.CD_NF
				WHERE 
					s.STS_NF<>0 
					OR s.PEND_ENTRADA<>0

			--Pendncia de entrada vendas grupo econmico
				INSERT INTO EST_NF_SAI_PENDENCIA(CD_EMP, CD_FILIAL, CD_NF, CD_FILIAL_DEST)
				SELECT  DISTINCT 
					s.CD_EMP, 
					s.CD_FILIAL, 
					s.CD_NF, 
					r.CD_FILIAL
				FROM 
					INSERTED s 
					INNER JOIN PRC_FILIAL_RC_CLI r ON 
					s.CD_EMP=r.CD_EMP AND 
					s.CD_CLI=r.CD_CLI
				WHERE 
					s.STS_NF=0 
					AND s.PEND_ENTRADA=0                 --transacao de saida, preco custo
					AND CD_NT_MOV IN (SELECT CD_MOV_OP FROM GLB_MOV_OP WHERE TP_MOV_OP_TRANSA=1 AND DEST_ORIG= 0 AND TP_MOV <> 28)
					AND s.CD_FILIAL <> r.CD_FILIAL
					AND NOT EXISTS (SELECT TOP 1 CD_EMP
									FROM 
										EST_NF_ENT_EST_NF_SAI_TRANSF   --ainda sem registro de transferncia
									WHERE 
										CD_NF_SAI=s.CD_NF AND 
										CD_EMP=s.CD_EMP AND 
										CD_FIL_ORIG=s.CD_FILIAL and
										CD_FIL_DEST= r.CD_FILIAL)
					AND NOT EXISTS (SELECT TOP 1 CD_EMP
									FROM 
										EST_NF_SAI_PENDENCIA
									WHERE 
										CD_FILIAL=s.CD_FILIAL AND 
										CD_EMP=s.CD_EMP AND 
										CD_NF=s.CD_NF); 

			--Pendente de entrada outras saidas para o grupo econmico
				INSERT INTO EST_NF_SAI_PENDENCIA(CD_EMP, CD_FILIAL, CD_NF, CD_FILIAL_DEST)
				SELECT DISTINCT 
					s.CD_EMP, 
					s.CD_FILIAL AS CD_FILIAL_ORIG, 
					s.CD_NF, 
					f.CD_FILIAL AS CD_FILIAL_DEST
				FROM 
					INSERTED s 
					INNER JOIN PRC_FILIAL_PG_FORN f ON 
					s.CD_EMP=f.CD_EMP AND 
					s.CD_CLI=f.CD_FORN AND 
					s.CD_FILIAL <> f.CD_FILIAL
				WHERE 
					s.STS_NF=0 
					AND s.PEND_ENTRADA=0 --transacao de saida, preco custo
					AND CD_NT_MOV IN (SELECT CD_MOV_OP FROM GLB_MOV_OP WHERE TP_MOV_OP_TRANSA=1 AND DEST_ORIG=1 AND TP_MOV <> 28)
					AND NOT EXISTS (SELECT 
										* 
									FROM 
										EST_NF_ENT_EST_NF_SAI_TRANSF
									WHERE 
										CD_NF_SAI=s.CD_NF 
										AND CD_EMP=s.CD_EMP 
										AND CD_FIL_ORIG=s.CD_FILIAL)
					AND NOT EXISTS (SELECT 
										* 
									FROM EST_NF_SAI_PENDENCIA
									WHERE CD_FILIAL=s.CD_FILIAL AND 
											CD_EMP=s.CD_EMP AND 
											CD_NF=s.CD_NF);

			--Pendente de entrada outras saidas para o grupo econmico
				INSERT INTO EST_NF_SAI_PENDENCIA(CD_EMP, CD_FILIAL, CD_NF, CD_FILIAL_DEST)
				SELECT DISTINCT 
					s.CD_EMP, 
					s.CD_FILIAL AS CD_FILIAL_ORIG, 
					s.CD_NF, 
					s.CD_FILIAL AS CD_FILIAL_DEST
				FROM 
					INSERTED s
					INNER JOIN EST_NF_SAI_PED_VD V ON
						S.CD_EMP = V.CD_EMP
						AND S.CD_FILIAL = V.CD_FILIAL
						AND S.CD_NF = V.CD_NF
					INNER JOIN EST_PED_VD P ON
						V.CD_EMP = P.CD_EMP
						AND V.CD_FILIAL = P.CD_FILIAL
						AND V.CD_PED = P.CD_PED
				WHERE 
					s.STS_NF=0
					AND P.FLAG_GRAVA_PENDENCIA = 1
					AND NOT EXISTS (SELECT 
										* 
									FROM 
										EST_NF_ENT_EST_NF_SAI_TRANSF
									WHERE 
										CD_NF_SAI=s.CD_NF 
										AND CD_EMP=s.CD_EMP 
										AND CD_FIL_ORIG=s.CD_FILIAL)
					AND NOT EXISTS (SELECT 
										* 
									FROM EST_NF_SAI_PENDENCIA
									WHERE CD_FILIAL=s.CD_FILIAL AND 
											CD_EMP=s.CD_EMP AND 
											CD_NF=s.CD_NF);
		END

